"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = require("mongoose");
const referenciaStatus = ['Pendente', 'Paga', 'Expirada'];
const referenciaSchema = new mongoose_1.Schema({
    entidade: {
        type: Number,
    },
    montante: {
        type: String,
    },
    ref: {
        type: Number,
    },
    dadosPessoais: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'DadosPessoais'
    },
    emolumento: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'Emolumento'
    },
    dataExpiracao: {
        type: Date,
    },
    status: {
        type: String,
        enum: referenciaStatus,
        default: 'Pendente'
    },
    admin: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'UserAdmin'
    },
}, { timestamps: true });
const Referencia = (0, mongoose_1.model)('Referencia', referenciaSchema);
exports.default = Referencia;
