"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = require("mongoose");
const requerimentoSchema = new mongoose_1.Schema({
    tipo: {
        type: String,
        enum: ['Membro']
    },
    profissao: {
        type: String
    },
    gozoDireito: {
        type: String,
        required: true,
    },
    dadosPessoais: {
        type: mongoose_1.Schema.Types.ObjectId,
        required: true,
        ref: 'DadosPessoais',
    },
}, { timestamps: true });
const Requerimento = (0, mongoose_1.model)('Requerimento', requerimentoSchema);
exports.default = Requerimento;
