"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = require("mongoose");
const SiteInfoSchema = new mongoose_1.Schema({
    menu: {
        type: String,
    },
    opcao: {
        type: String,
    },
    conteudo: {
        type: String,
    },
    imagem: {
        type: String,
    },
    status: {
        type: String,
        enum: ['Activo', 'Inactivo'],
        default: 'Activo'
    },
    admin: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'User'
    }
}, { timestamps: true });
const SiteInfo = (0, mongoose_1.model)('SiteInfo', SiteInfoSchema);
exports.default = SiteInfo;
